</main>
        </div>
    </div>
    
    <!-- Bootstrap JS dari CDN -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script>
        /**
         * Script.js
         * File ini berisi fungsi-fungsi JavaScript untuk aplikasi
         */

        // Fungsi untuk menginisialisasi chart dari data JSON
        function initChart(chartId, chartData, chartType = 'line') {
            const ctx = document.getElementById(chartId);
            
            if (!ctx) {
                console.error(`Canvas with id ${chartId} not found.`);
                return null;
            }
            
            let data;
            try {
                data = typeof chartData === 'string' ? JSON.parse(chartData) : chartData;
            } catch (e) {
                console.error('Invalid chart data', e);
                return null;
            }
            
            return new Chart(ctx, {
                type: chartType,
                data: data,
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        x: {
                            title: {
                                display: true,
                                text: 'Tanggal'
                            }
                        },
                        y: {
                            title: {
                                display: true,
                                text: 'Harga (Rp)'
                            },
                            beginAtZero: false
                        }
                    }
                }
            });
        }

        // Fungsi untuk validasi form upload
        function validateUploadForm() {
            const fileInput = document.getElementById('csv_file');
            
            if (!fileInput || !fileInput.files || fileInput.files.length === 0) {
                alert('Pilih file CSV terlebih dahulu.');
                return false;
            }
            
            const file = fileInput.files[0];
            const fileType = file.name.split('.').pop().toLowerCase();
            
            if (fileType !== 'csv') {
                alert('File harus berformat CSV.');
                return false;
            }
            
            return true;
        }

        // Fungsi untuk validasi form training
        function validateTrainingForm() {
            const trainTestRatio = parseFloat(document.getElementById('train_test_ratio').value);
            const nEstimators = parseInt(document.getElementById('n_estimators').value);
            
            if (isNaN(trainTestRatio) || trainTestRatio <= 0 || trainTestRatio >= 1) {
                alert('Rasio training-testing harus antara 0 dan 1.');
                return false;
            }
            
            if (isNaN(nEstimators) || nEstimators <= 0) {
                alert('Jumlah estimator harus lebih dari 0.');
                return false;
            }
            
            return true;
        }

        // Fungsi untuk konfirmasi reset data
        function confirmReset() {
            return confirm('Anda yakin ingin menghapus semua data saham? Tindakan ini tidak dapat dibatalkan.');
        }

        // Event listener saat halaman dimuat
        document.addEventListener('DOMContentLoaded', function() {
            // Set active class di sidebar berdasarkan URL saat ini
            const currentPath = window.location.pathname;
            const navLinks = document.querySelectorAll('.sidebar .nav-link');
            
            navLinks.forEach(link => {
                if (currentPath.includes(link.getAttribute('href'))) {
                    link.classList.add('active');
                } else {
                    link.classList.remove('active');
                }
            });
            
            // Initialize Bootstrap tooltips
            const tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
            tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl);
            });
        });
    </script>
</body>
</html>