<?php
/**
 * View Data Page
 * Halaman untuk melihat data saham
 */

// Mengimpor file konfigurasi
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../controller/stock_controller.php';

// Definisikan BASE_URL jika belum didefinisikan
if (!defined('BASE_URL')) {
    define('BASE_URL', '/bri_stock_prediction');
}

// Cek status login
redirectIfNotLoggedIn();

// Dapatkan halaman saat ini
$page = isset($_GET['page']) ? (int) $_GET['page'] : 1;

// Dapatkan data dengan pagination
$stockData = getStockDataPaginated($page, 20);
?>

<?php include __DIR__ . '/../templates/header.php'; ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Data Historis Saham</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="<?php echo BASE_URL; ?>/view/stock/upload.php" class="btn btn-sm btn-outline-primary me-2">
            <i class="bi bi-upload"></i> Upload Data
        </a>
        <button type="button" class="btn btn-sm btn-outline-danger" data-bs-toggle="modal" data-bs-target="#resetModal">
            <i class="bi bi-trash"></i> Reset Data
        </button>
    </div>
</div>

<!-- Tabel Data -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title">Data Historis Saham BRI</h5>
        <p class="card-text">Total data: <?php echo number_format($stockData['pagination']['total_data']); ?></p>
    </div>
    <div class="card-body">
        <?php if (empty($stockData['data'])): ?>
        <div class="alert alert-info">
            Belum ada data saham. Silakan upload data terlebih dahulu.
        </div>
        <?php else: ?>
        <div class="table-responsive">
            <table class="table table-striped table-hover table-sm stock-table">
                <thead>
                    <tr>
                        <th>Tanggal</th>
                        <th>Pembukaan</th>
                        <th>Tertinggi</th>
                        <th>Terendah</th>
                        <th>Penutupan</th>
                        <th>Adj. Close</th>
                        <th>Volume</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($stockData['data'] as $data): ?>
                    <tr>
                        <td><?php echo $data['date']; ?></td>
                        <td>Rp <?php echo number_format($data['open'], 2); ?></td>
                        <td>Rp <?php echo number_format($data['high'], 2); ?></td>
                        <td>Rp <?php echo number_format($data['low'], 2); ?></td>
                        <td>Rp <?php echo number_format($data['close'], 2); ?></td>
                        <td>Rp <?php echo number_format($data['adj_close'], 2); ?></td>
                        <td><?php echo number_format($data['volume']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination -->
        <?php if ($stockData['pagination']['total_pages'] > 1): ?>
        <nav aria-label="Page navigation">
            <ul class="pagination justify-content-center">
                <?php if ($stockData['pagination']['page'] > 1): ?>
                <li class="page-item">
                    <a class="page-link" href="<?php echo BASE_URL; ?>/view/stock/view.php?page=<?php echo $stockData['pagination']['page'] - 1; ?>">Sebelumnya</a>
                </li>
                <?php endif; ?>
                
                <?php
                $startPage = max(1, $stockData['pagination']['page'] - 2);
                $endPage = min($stockData['pagination']['total_pages'], $stockData['pagination']['page'] + 2);
                
                for ($i = $startPage; $i <= $endPage; $i++):
                ?>
                <li class="page-item <?php echo $i == $stockData['pagination']['page'] ? 'active' : ''; ?>">
                    <a class="page-link" href="<?php echo BASE_URL; ?>/view/stock/view.php?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                </li>
                <?php endfor; ?>
                
                <?php if ($stockData['pagination']['page'] < $stockData['pagination']['total_pages']): ?>
                <li class="page-item">
                    <a class="page-link" href="<?php echo BASE_URL; ?>/view/stock/view.php?page=<?php echo $stockData['pagination']['page'] + 1; ?>">Selanjutnya</a>
                </li>
                <?php endif; ?>
            </ul>
        </nav>
        <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<!-- Grafik -->
<?php if (!empty($stockData['data'])): ?>
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Grafik Harga Saham BRI</h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="stockChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Modal Reset Data -->
<div class="modal fade" id="resetModal" tabindex="-1" aria-labelledby="resetModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="resetModalLabel">Konfirmasi Reset Data</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Anda yakin ingin menghapus semua data saham? Tindakan ini tidak dapat dibatalkan.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                <form action="<?php echo BASE_URL; ?>/view/stock/delete.php" method="post">
                    <input type="hidden" name="confirm_reset" value="yes">
                    <button type="submit" class="btn btn-danger">Hapus Semua Data</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../templates/footer.php'; ?>

<?php if (!empty($stockData['data'])): ?>
<script>
// Ambil data untuk grafik
document.addEventListener('DOMContentLoaded', function() {
    // Persiapkan data
    const chartData = {
        labels: <?php echo json_encode(array_column(array_reverse(array_slice($stockData['data'], 0, 30)), 'date')); ?>,
        datasets: [
            {
                label: 'Harga Penutupan',
                data: <?php echo json_encode(array_column(array_reverse(array_slice($stockData['data'], 0, 30)), 'close')); ?>,
                borderColor: 'rgba(75, 192, 192, 1)',
                backgroundColor: 'rgba(75, 192, 192, 0.2)',
                borderWidth: 1,
                fill: false
            }
        ]
    };
    
    // Inisialisasi chart
    initChart('stockChart', chartData);
});
</script>
<?php endif; ?>