<?php
/**
 * Upload Page
 * Halaman untuk mengupload data saham
 */

// Mengimpor file konfigurasi
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../controller/stock_controller.php';

// Definisikan BASE_URL jika belum didefinisikan
if (!defined('BASE_URL')) {
    define('BASE_URL', '/bri_stock_prediction');
}

// Cek status login
redirectIfNotLoggedIn();

// Proses upload jika form disubmit
handleUpload();
?>

<?php include __DIR__ . '/../templates/header.php'; ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Upload Data Saham</h1>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Upload File CSV</h5>
            </div>
            <div class="card-body">
                <form action="" method="post" enctype="multipart/form-data" onsubmit="return validateUploadForm()">
                    <div class="mb-3">
                        <label for="csv_file" class="form-label">Pilih File CSV</label>
                        <input class="form-control" type="file" id="csv_file" name="csv_file" accept=".csv" required>
                        <div class="form-text">Format file harus CSV dari Yahoo Finance. Aplikasi mendukung format baru maupun lama.</div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Upload dan Proses</button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Panduan Format</h5>
            </div>
            <div class="card-body">
                <h6>Format Baru Yahoo Finance:</h6>
                <p>File CSV dari Yahoo Finance sekarang memiliki format sebagai berikut:</p>
                <pre class="bg-light p-2">
Date,Open,High,Low,Close,Volume,Adj Close
2025-04-22,3600.00,3650.00,3600.00,3630.00,147116900,3630.00
2025-04-21,3620.00,3660.00,3570.00,3620.00,107470200,3620.00
...
                </pre>
                
                <h6 class="mt-3">Format Lama Yahoo Finance:</h6>
                <p>Aplikasi juga mendukung format lama:</p>
                <pre class="bg-light p-2">
Date,Open,High,Low,Close,Adj Close,Volume
2025-04-22,3600.00,3650.00,3600.00,3630.00,3630.00,147116900
2025-04-21,3620.00,3660.00,3570.00,3620.00,3620.00,107470200
...
                </pre>

                <h6 class="mt-3">Cara Mendapatkan Data:</h6>
                <ol>
                    <li>Kunjungi <a href="https://finance.yahoo.com" target="_blank">Yahoo Finance</a></li>
                    <li>Cari saham BRI (BBRI.JK)</li>
                    <li>Pilih tab "Historical Data"</li>
                    <li>Pilih rentang waktu yang diinginkan</li>
                    <li>Klik "Download"</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../templates/footer.php'; ?>