<?php
/**
 * Settings Page
 * Halaman untuk mengatur parameter model
 */

// Mengimpor file konfigurasi
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../controller/settings_controller.php';

// Cek status login
redirectIfNotLoggedIn();

// Proses simpan pengaturan jika form disubmit
handleSaveSettings();

// Dapatkan pengaturan model
$settings = getModelSettings();
?>

<?php include __DIR__ . '/../templates/header.php'; ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Pengaturan Model</h1>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Parameter Default Model</h5>
            </div>
            <div class="card-body">
                <form action="" method="post" class="settings-form">
                    <div class="mb-3">
                        <label for="train_test_ratio" class="form-label">Rasio Training-Testing</label>
                        <input type="number" class="form-control" id="train_test_ratio" name="train_test_ratio" value="<?php echo $settings['latest']['train_test_ratio']; ?>" min="0.1" max="0.95" step="0.05" required>
                        <div class="form-text">Rasio untuk membagi data training dan testing (0-1).</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="n_estimators" class="form-label">Jumlah Estimator (Trees)</label>
                        <input type="number" class="form-control" id="n_estimators" name="n_estimators" value="<?php echo $settings['latest']['n_estimators']; ?>" min="10" max="1000" step="10" required>
                        <div class="form-text">Jumlah pohon (trees) yang akan dibuat dalam Random Forest.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="max_depth" class="form-label">Kedalaman Maksimal (Max Depth)</label>
                        <input type="number" class="form-control" id="max_depth" name="max_depth" value="<?php echo $settings['latest']['max_depth']; ?>" min="0" step="1">
                        <div class="form-text">Kedalaman maksimal pohon. Kosongkan untuk tidak dibatasi.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="min_samples_split" class="form-label">Sampel Minimal untuk Split</label>
                        <input type="number" class="form-control" id="min_samples_split" name="min_samples_split" value="<?php echo $settings['latest']['min_samples_split']; ?>" min="2" step="1" required>
                        <div class="form-text">Jumlah sampel minimal yang dibutuhkan untuk memecah node internal.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="min_samples_leaf" class="form-label">Sampel Minimal untuk Leaf</label>
                        <input type="number" class="form-control" id="min_samples_leaf" name="min_samples_leaf" value="<?php echo $settings['latest']['min_samples_leaf']; ?>" min="1" step="1" required>
                        <div class="form-text">Jumlah sampel minimal yang dibutuhkan untuk menjadi leaf node.</div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Simpan Pengaturan</button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Riwayat Pengaturan</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Rasio</th>
                                <th>Trees</th>
                                <th>Tanggal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($settings['all'] as $setting): ?>
                            <tr>
                                <td><?php echo $setting['id']; ?></td>
                                <td><?php echo $setting['train_test_ratio']; ?></td>
                                <td><?php echo $setting['n_estimators']; ?></td>
                                <td><?php echo date('d/m/Y', strtotime($setting['created_at'])); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title">Panduan Pengaturan</h5>
            </div>
            <div class="card-body">
                <h6>Panduan parameter Random Forest:</h6>
                <p>Pengaturan ini akan digunakan sebagai default saat melakukan training model. Anda tetap dapat mengubahnya saat training.</p>
                
                <h6>Rekomendasi:</h6>
                <ul>
                    <li><strong>Rasio:</strong> 0.7 - 0.8</li>
                    <li><strong>Estimators:</strong> 100 - 500</li>
                    <li><strong>Max Depth:</strong> Kosongkan untuk auto</li>
                    <li><strong>Min Samples Split:</strong> 2</li>
                    <li><strong>Min Samples Leaf:</strong> 1</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../templates/footer.php'; ?>