<?php
/**
 * Train Model Page
 * Halaman untuk melatih model Random Forest
 */

// Mengimpor file konfigurasi
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../controller/prediction_controller.php';
require_once __DIR__ . '/../../controller/settings_controller.php';

// Cek status login
redirectIfNotLoggedIn();

// Proses training jika form disubmit
handleTraining();

// Dapatkan pengaturan model
$settings = getModelSettings();
?>

<?php include __DIR__ . '/../templates/header.php'; ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Training Model Random Forest</h1>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Parameter Model</h5>
            </div>
            <div class="card-body">
                <form action="" method="post" onsubmit="return validateTrainingForm()">
                    <div class="mb-3">
                        <label for="train_test_ratio" class="form-label">Rasio Training-Testing</label>
                        <input type="number" class="form-control" id="train_test_ratio" name="train_test_ratio" value="<?php echo $settings['latest']['train_test_ratio']; ?>" min="0.1" max="0.95" step="0.05" required>
                        <div class="form-text">Rasio untuk membagi data training dan testing (0-1). Contoh: 0.8 berarti 80% data untuk training, 20% untuk testing.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="n_estimators" class="form-label">Jumlah Estimator (Trees)</label>
                        <input type="number" class="form-control" id="n_estimators" name="n_estimators" value="<?php echo $settings['latest']['n_estimators']; ?>" min="10" max="1000" step="10" required>
                        <div class="form-text">Jumlah pohon (trees) yang akan dibuat dalam Random Forest.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="max_depth" class="form-label">Kedalaman Maksimal (Max Depth)</label>
                        <input type="number" class="form-control" id="max_depth" name="max_depth" value="<?php echo $settings['latest']['max_depth']; ?>" min="0" step="1">
                        <div class="form-text">Kedalaman maksimal pohon. Kosongkan untuk tidak dibatasi.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="min_samples_split" class="form-label">Sampel Minimal untuk Split</label>
                        <input type="number" class="form-control" id="min_samples_split" name="min_samples_split" value="<?php echo $settings['latest']['min_samples_split']; ?>" min="2" step="1" required>
                        <div class="form-text">Jumlah sampel minimal yang dibutuhkan untuk memecah node internal.</div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="min_samples_leaf" class="form-label">Sampel Minimal untuk Leaf</label>
                        <input type="number" class="form-control" id="min_samples_leaf" name="min_samples_leaf" value="<?php echo $settings['latest']['min_samples_leaf']; ?>" min="1" step="1" required>
                        <div class="form-text">Jumlah sampel minimal yang dibutuhkan untuk menjadi leaf node.</div>
                    </div>
                    
                    <button type="submit" class="btn btn-primary">Training Model</button>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Keterangan Parameter</h5>
            </div>
            <div class="card-body">
                <h6>Rasio Training-Testing:</h6>
                <p>Menentukan berapa bagian data yang digunakan untuk training dan testing. Nilai umum antara 0.7-0.8.</p>
                
                <h6>Jumlah Estimator:</h6>
                <p>Semakin banyak jumlah pohon (trees), semakin baik model tetapi semakin lama proses training. Nilai umum antara 100-500.</p>
                
                <h6>Kedalaman Maksimal:</h6>
                <p>Mengontrol kompleksitas model. Nilai yang terlalu tinggi dapat menyebabkan overfitting, nilai yang terlalu rendah dapat menyebabkan underfitting. Kosongkan untuk tidak dibatasi.</p>
                
                <h6>Sampel Minimal untuk Split dan Leaf:</h6>
                <p>Mengontrol ukuran pohon dan membantu mencegah overfitting. Nilai default yang biasa digunakan adalah 2 untuk split dan 1 untuk leaf.</p>
                
                <h6>Catatan:</h6>
                <p>Training model akan menggunakan data historis yang sudah diupload. Pastikan data sudah cukup untuk membuat model yang baik.</p>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../templates/footer.php'; ?>