<?php
/**
 * Result Page
 * Halaman untuk menampilkan hasil prediksi
 */

// Mengimpor file konfigurasi
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../controller/prediction_controller.php';

// Cek status login
redirectIfNotLoggedIn();

// Dapatkan model ID dari parameter URL
$modelId = isset($_GET['model_id']) ? (int) $_GET['model_id'] : null;

// Dapatkan hasil prediksi
$predictionResults = getPredictionResults($modelId);
?>

<?php include __DIR__ . '/../templates/header.php'; ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Hasil Prediksi</h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/bri_stock_prediction/view/prediction/export.php<?php echo $modelId ? '?model_id=' . $modelId : ''; ?>" class="btn btn-sm btn-outline-primary">
            <i class="bi bi-download"></i> Export CSV
        </a>
    </div>
</div>

<?php if (empty($predictionResults['predictions'])): ?>
<div class="alert alert-info">
    Belum ada hasil prediksi. Silakan lakukan training model terlebih dahulu.
</div>
<?php else: ?>

<!-- Informasi Model -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title">Informasi Model</h5>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <table class="table">
                    <tr>
                        <th>ID Model</th>
                        <td><?php echo $predictionResults['model_settings']['id']; ?></td>
                    </tr>
                    <tr>
                        <th>Rasio Training-Testing</th>
                        <td><?php echo $predictionResults['model_settings']['train_test_ratio']; ?> (<?php echo $predictionResults['model_settings']['train_test_ratio'] * 100; ?>% : <?php echo (1 - $predictionResults['model_settings']['train_test_ratio']) * 100; ?>%)</td>
                    </tr>
                    <tr>
                        <th>Jumlah Estimator</th>
                        <td><?php echo $predictionResults['model_settings']['n_estimators']; ?></td>
                    </tr>
                    <tr>
                        <th>Kedalaman Maksimal</th>
                        <td><?php echo $predictionResults['model_settings']['max_depth'] ? $predictionResults['model_settings']['max_depth'] : 'Tidak dibatasi'; ?></td>
                    </tr>
                </table>
            </div>
            <div class="col-md-6">
                <table class="table">
                    <tr>
                        <th>Sampel Minimal Split</th>
                        <td><?php echo $predictionResults['model_settings']['min_samples_split']; ?></td>
                    </tr>
                    <tr>
                        <th>Sampel Minimal Leaf</th>
                        <td><?php echo $predictionResults['model_settings']['min_samples_leaf']; ?></td>
                    </tr>
                    <tr>
                        <th>Tanggal Training</th>
                        <td><?php echo date('d-m-Y H:i:s', strtotime($predictionResults['model_settings']['created_at'])); ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Evaluasi Model -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Evaluasi Model</h5>
            </div>
            <div class="card-body">
                <?php if ($predictionResults['evaluation']): ?>
                <table class="table">
                    <tr>
                        <th>Mean Absolute Error (MAE)</th>
                        <td>Rp <?php echo number_format($predictionResults['evaluation']['mae'], 4); ?></td>
                    </tr>
                    <tr>
                        <th>Root Mean Square Error (RMSE)</th>
                        <td>Rp <?php echo number_format($predictionResults['evaluation']['rmse'], 4); ?></td>
                    </tr>
                </table>
                
                <div class="alert alert-info">
                    <p><strong>MAE</strong> (Mean Absolute Error): Rata-rata kesalahan absolut antara nilai prediksi dan nilai aktual.</p>
                    <p><strong>RMSE</strong> (Root Mean Square Error): Akar kuadrat dari rata-rata kesalahan kuadrat. Nilai yang lebih kecil menunjukkan model yang lebih akurat.</p>
                </div>
                <?php else: ?>
                <div class="alert alert-warning">
                    Data evaluasi model tidak tersedia.
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Statistik Prediksi</h5>
            </div>
            <div class="card-body">
                <?php
                $actualPrices = array_column($predictionResults['predictions'], 'actual_price');
                $predictedPrices = array_column($predictionResults['predictions'], 'predicted_price');
                $errors = array_map(function($a, $p) { return abs($a - $p); }, $actualPrices, $predictedPrices);
                
                $minError = min($errors);
                $maxError = max($errors);
                $avgError = array_sum($errors) / count($errors);
                $totalPredictions = count($predictionResults['predictions']);
                ?>
                
                <table class="table">
                    <tr>
                        <th>Jumlah Prediksi</th>
                        <td><?php echo $totalPredictions; ?></td>
                    </tr>
                    <tr>
                        <th>Error Minimal</th>
                        <td>Rp <?php echo number_format($minError, 4); ?></td>
                    </tr>
                    <tr>
                        <th>Error Maksimal</th>
                        <td>Rp <?php echo number_format($maxError, 4); ?></td>
                    </tr>
                    <tr>
                        <th>Rata-rata Error</th>
                        <td>Rp <?php echo number_format($avgError, 4); ?></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Grafik -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Grafik Harga Aktual vs Prediksi</h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="predictionChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Grafik Error Prediksi</h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="errorChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tabel Hasil Prediksi -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="card-title">Tabel Hasil Prediksi</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped table-hover table-sm stock-table">
                <thead>
                    <tr>
                        <th>Tanggal</th>
                        <th>Harga Aktual</th>
                        <th>Harga Prediksi</th>
                        <th>Error</th>
                        <th>Error (%)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($predictionResults['predictions'] as $prediction): ?>
                    <tr>
                        <td><?php echo $prediction['date']; ?></td>
                        <td>Rp <?php echo number_format($prediction['actual_price'], 2); ?></td>
                        <td>Rp <?php echo number_format($prediction['predicted_price'], 2); ?></td>
                        <td>Rp <?php echo number_format($prediction['error'], 2); ?></td>
                        <td><?php echo number_format(($prediction['error'] / $prediction['actual_price']) * 100, 2); ?>%</td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php endif; ?>

<?php include __DIR__ . '/../templates/footer.php'; ?>

<?php if (!empty($predictionResults['predictions'])): ?>
<script>
// Inisialisasi chart
document.addEventListener('DOMContentLoaded', function() {
    // Chart prediksi
    initChart('predictionChart', <?php echo $predictionResults['prediction_chart_data']; ?>);
    
    // Chart error
    initChart('errorChart', <?php echo $predictionResults['error_chart_data']; ?>, 'bar');
});
</script>
<?php endif; ?>