<?php
/**
 * Dashboard Page
 * Halaman utama setelah login
 */

// Mengimpor file konfigurasi
require_once __DIR__ . '/../../config/database.php';
require_once __DIR__ . '/../../config/session.php';
require_once __DIR__ . '/../../controller/dashboard_controller.php';

// Cek status login
redirectIfNotLoggedIn();

// Dapatkan data dashboard
$dashboardData = getDashboardData();
$statisticsData = getStatisticsSummary();
?>

<?php include __DIR__ . '/../templates/header.php'; ?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2">Dashboard</h1>
</div>

<!-- Statistik -->
<div class="row mb-4">
    <div class="col-md-3 mb-4">
        <div class="card stat-card bg-primary text-white">
            <div class="card-body">
                <h5 class="card-title">Total Data</h5>
                <h2 class="card-text"><?php echo number_format($dashboardData['stock_count']); ?></h2>
                <p class="card-text">Jumlah data historis</p>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 mb-4">
        <div class="card stat-card bg-success text-white">
            <div class="card-body">
                <h5 class="card-title">Harga Terakhir</h5>
                <h2 class="card-text">Rp <?php echo number_format($statisticsData['last_price'], 2); ?></h2>
                <p class="card-text">Harga penutupan terakhir</p>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 mb-4">
        <div class="card stat-card bg-info text-white">
            <div class="card-body">
                <h5 class="card-title">Perubahan</h5>
                <h2 class="card-text"><?php echo ($statisticsData['price_change'] >= 0 ? '+' : ''); ?><?php echo number_format($statisticsData['price_change_percent'], 2); ?>%</h2>
                <p class="card-text">Perubahan harga 30 hari</p>
            </div>
        </div>
    </div>
    
    <div class="col-md-3 mb-4">
        <div class="card stat-card bg-warning text-dark">
            <div class="card-body">
                <h5 class="card-title">Harga Rata-rata</h5>
                <h2 class="card-text">Rp <?php echo number_format($statisticsData['avg_price'], 2); ?></h2>
                <p class="card-text">Rata-rata 30 hari terakhir</p>
            </div>
        </div>
    </div>
</div>

<!-- Grafik Harga Saham -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Grafik Harga Saham BRI</h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="stockChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Grafik Prediksi (jika ada) -->
<?php if ($dashboardData['prediction_chart_data']): ?>
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Grafik Prediksi vs Aktual</h5>
            </div>
            <div class="card-body">
                <div class="chart-container">
                    <canvas id="predictionChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<!-- Data Terbaru -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Data Harga Terakhir</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-sm stock-table">
                        <thead>
                            <tr>
                                <th>Tanggal</th>
                                <th>Pembukaan</th>
                                <th>Tertinggi</th>
                                <th>Terendah</th>
                                <th>Penutupan</th>
                                <th>Adj. Close</th>
                                <th>Volume</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach (array_slice($dashboardData['latest_data'], 0, 10) as $data): ?>
                            <tr>
                                <td><?php echo $data['date']; ?></td>
                                <td>Rp <?php echo number_format($data['open'], 2); ?></td>
                                <td>Rp <?php echo number_format($data['high'], 2); ?></td>
                                <td>Rp <?php echo number_format($data['low'], 2); ?></td>
                                <td>Rp <?php echo number_format($data['close'], 2); ?></td>
                                <td>Rp <?php echo number_format($data['adj_close'], 2); ?></td>
                                <td><?php echo number_format($data['volume']); ?></td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../templates/footer.php'; ?>

<script>
// Inisialisasi chart
document.addEventListener('DOMContentLoaded', function() {
    // Chart harga saham
    initChart('stockChart', <?php echo $dashboardData['stock_chart_data']; ?>);
    
    <?php if ($dashboardData['prediction_chart_data']): ?>
    // Chart prediksi
    initChart('predictionChart', <?php echo $dashboardData['prediction_chart_data']; ?>);
    <?php endif; ?>
});
</script>