<?php
/**
 * Model User
 * File ini berisi fungsi-fungsi terkait user dan autentikasi
 */

require_once __DIR__ . '/../config/database.php';

/**
 * Memverifikasi login user
 * 
 * @param string $username Username user
 * @param string $password Password user
 * @return array|false Data user jika login berhasil, false jika gagal
 */
function verifyUser($username, $password) {
    global $conn;
    
    // Sanitasi input
    $username = sanitizeInput($conn, $username);
    
    // Query untuk mendapatkan data user
    $sql = "SELECT id, username, password FROM users WHERE username = '$username'";
    $result = executeQuery($conn, $sql);
    
    if (mysqli_num_rows($result) == 1) {
        $user = fetchRow($result);
        
        // Verifikasi password
        if (password_verify($password, $user['password'])) {
            // Hapus password dari data yang dikembalikan
            unset($user['password']);
            return $user;
        }
    }
    
    return false;
}

/**
 * Mengubah password user
 * 
 * @param int $userId ID user
 * @param string $newPassword Password baru
 * @return bool True jika berhasil, false jika gagal
 */
function changePassword($userId, $newPassword) {
    global $conn;
    
    // Hash password
    $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);
    
    // Update password
    $sql = "UPDATE users SET password = '$hashedPassword' WHERE id = $userId";
    $result = executeQuery($conn, $sql);
    
    return mysqli_affected_rows($conn) > 0;
}

/**
 * Mendapatkan data user berdasarkan ID
 * 
 * @param int $userId ID user
 * @return array|false Data user jika ditemukan, false jika tidak
 */
function getUserById($userId) {
    global $conn;
    
    $sql = "SELECT id, username, created_at FROM users WHERE id = $userId";
    $result = executeQuery($conn, $sql);
    
    if (mysqli_num_rows($result) == 1) {
        return fetchRow($result);
    }
    
    return false;
}