<?php
/**
 * Settings Controller
 * File ini menangani pengaturan model
 */

require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/session.php';
require_once __DIR__ . '/../model/settings_model.php';

// Definisikan BASE_URL jika belum didefinisikan
if (!defined('BASE_URL')) {
    define('BASE_URL', '/bri_stock_prediction');
}

/**
 * Mendapatkan pengaturan model
 * 
 * @return array Pengaturan model
 */
function getModelSettings() {
    // Cek apakah user sudah login
    if (!isLoggedIn()) {
        header('Location: ' . BASE_URL . '/view/auth/login.php');
        exit;
    }
    
    // Dapatkan pengaturan model terbaru
    $latestSettings = getLatestModelSettings();
    
    // Dapatkan semua pengaturan model
    $allSettings = getAllModelSettings();
    
    return [
        'latest' => $latestSettings,
        'all' => $allSettings
    ];
}

/**
 * Menangani proses penyimpanan pengaturan model
 */
function handleSaveSettings() {
    // Cek apakah user sudah login
    if (!isLoggedIn()) {
        header('Location: ' . BASE_URL . '/view/auth/login.php');
        exit;
    }
    
    // Cek apakah form sudah disubmit
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        // Dapatkan parameter model
        $trainTestRatio = isset($_POST['train_test_ratio']) ? (float) $_POST['train_test_ratio'] : 0.8;
        $nEstimators = isset($_POST['n_estimators']) ? (int) $_POST['n_estimators'] : 100;
        $maxDepth = isset($_POST['max_depth']) && !empty($_POST['max_depth']) ? (int) $_POST['max_depth'] : NULL;
        $minSamplesSplit = isset($_POST['min_samples_split']) ? (int) $_POST['min_samples_split'] : 2;
        $minSamplesLeaf = isset($_POST['min_samples_leaf']) ? (int) $_POST['min_samples_leaf'] : 1;
        
        // Validasi parameter
        if ($trainTestRatio <= 0 || $trainTestRatio >= 1) {
            setFlashMessage('error', 'Rasio training-testing harus antara 0 dan 1');
            return;
        }
        
        if ($nEstimators <= 0) {
            setFlashMessage('error', 'Jumlah estimator harus lebih dari 0');
            return;
        }
        
        // Simpan pengaturan model
        $modelId = saveModelSettings(
            $trainTestRatio,
            $nEstimators,
            $maxDepth,
            $minSamplesSplit,
            $minSamplesLeaf
        );
        
        if ($modelId) {
            setFlashMessage('success', 'Pengaturan model berhasil disimpan');
            
            // Redirect ke halaman settings dengan BASE_URL
            header('Location: ' . BASE_URL . '/view/settings/index.php');
            exit;
        } else {
            setFlashMessage('error', 'Gagal menyimpan pengaturan model');
        }
    }
}